// DiskInfoKomponentDlg.cpp : implementation file
//

#include "stdafx.h"
#include "DiskInfoKomponent.h"
#include "DiskInfoKomponentDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CDiskInfoKomponentDlg dialog

#include "PanelZInformacjamiODysku.h"


CDiskInfoKomponentDlg::CDiskInfoKomponentDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CDiskInfoKomponentDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CDiskInfoKomponentDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CDiskInfoKomponentDlg, CDialog)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


// CDiskInfoKomponentDlg message handlers

BOOL CDiskInfoKomponentDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	//przygotowanie paneli
	const int przes = 10, wys = 30;
	int iloscPaneli = 0;
	CRect clientRect;
	GetClientRect(clientRect);
	PanelZInformacjamiODysku *panel;
   
	for(char litera = 'c'; litera <= 'z'; litera++)
	{
		panel = new PanelZInformacjamiODysku(litera);   
		if(panel->Informacje.czyDyskDostepny)
		{      
			panel->Create(WS_CHILD | WS_VISIBLE, clientRect, this, iloscPaneli);
			panel->MoveWindow(przes, przes + iloscPaneli * (wys + przes), clientRect.Width() - 2*przes, wys);
			iloscPaneli++;
		}
		else delete panel;
	}
   
	// Dopasowanie wysokoci okna dialogowego do iloci paneli
	int newHeight = (iloscPaneli+1) * (wys + przes);
	SetWindowPos(NULL, clientRect.left, clientRect.bottom, clientRect.Width(), newHeight, SWP_SHOWWINDOW);

	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CDiskInfoKomponentDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CDiskInfoKomponentDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

